/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.init;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.registries.ObjectHolder;
import novamachina.exnihilosequentia.common.blockentity.barrel.mode.BarrelModeRegistry;
import novamachina.exnihilosequentia.common.compat.top.CompatTOP;
import novamachina.exnihilosequentia.common.crafting.compost.CompostRecipe;
import novamachina.exnihilosequentia.common.crafting.crook.CrookRecipe;
import novamachina.exnihilosequentia.common.crafting.crucible.CrucibleRecipe;
import novamachina.exnihilosequentia.common.crafting.fluiditem.FluidItemRecipe;
import novamachina.exnihilosequentia.common.crafting.fluidontop.FluidOnTopRecipe;
import novamachina.exnihilosequentia.common.crafting.fluidtransform.FluidTransformRecipe;
import novamachina.exnihilosequentia.common.crafting.hammer.HammerRecipe;
import novamachina.exnihilosequentia.common.crafting.heat.HeatRecipe;
import novamachina.exnihilosequentia.common.crafting.sieve.SieveRecipe;
import novamachina.exnihilosequentia.common.init.ExNihiloBlockEntities;
import novamachina.exnihilosequentia.common.init.ExNihiloBlocks;
import novamachina.exnihilosequentia.common.init.ExNihiloFluids;
import novamachina.exnihilosequentia.common.init.ExNihiloItems;
import novamachina.exnihilosequentia.common.init.ExNihiloSerializers;
import novamachina.exnihilosequentia.common.init.ExNihiloStats;
import novamachina.exnihilosequentia.common.item.ResourceItem;
import novamachina.exnihilosequentia.common.item.SeedBaseItem;
import novamachina.exnihilosequentia.common.network.PacketHandler;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.common.utility.Config;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;
import org.apache.logging.log4j.LogManager;

@Mod.EventBusSubscriber(modid="exnihilosequentia", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ExNihiloInitialization {
    @Nonnull
    public static final CreativeModeTab ITEM_GROUP = new CreativeModeTab("exnihilosequentia"){

        @Nonnull
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ExNihiloBlocks.SIEVE_OAK.get());
        }
    };
    @ObjectHolder(value="exnihilosequentia:use_hammer")
    @Nullable
    public static final GlobalLootModifierSerializer<?> hammerModifier = null;
    @ObjectHolder(value="exnihilosequentia:use_crook")
    @Nullable
    public static final GlobalLootModifierSerializer<?> crookModifier = null;
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogManager.getLogger());

    private ExNihiloInitialization() {
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clearRegistries(@Nonnull ClientPlayerNetworkEvent.LoggedOutEvent event) {
        logger.debug("Fired LoggedOutEvent");
        ExNihiloRegistries.clearRegistries();
    }

    public static void init(@Nonnull IEventBus modEventBus) {
        logger.debug("Initializing modded items");
        ExNihiloBlocks.init(modEventBus);
        ExNihiloItems.init(modEventBus);
        ExNihiloBlockEntities.init(modEventBus);
        ExNihiloFluids.init(modEventBus);
        ExNihiloSerializers.init(modEventBus);
    }

    @SubscribeEvent
    public static void loadClientRecipes(@Nonnull RecipesUpdatedEvent event) {
        ExNihiloRegistries.clearRegistries();
        ExNihiloInitialization.loadRecipes(event.getRecipeManager());
    }

    @SubscribeEvent
    public static void onPlayerLogin(@Nonnull PlayerEvent.PlayerLoggedInEvent event) {
        logger.debug("Fired PlayerLoggedInEvent");
    }

    @SubscribeEvent
    public static void onServerStart(@Nonnull ServerStartingEvent event) {
        logger.debug("Fired FMLServerStartingEvent");
        ExNihiloInitialization.registerOreCompat();
        ExNihiloInitialization.overrideOres();
        if (event.getServer().m_6982_()) {
            ExNihiloInitialization.loadRecipes(event.getServer().m_129894_());
        }
    }

    @SubscribeEvent
    public static void registerTOP(@Nonnull InterModEnqueueEvent event) {
        logger.debug("The One Probe detected: " + ModList.get().isLoaded("theoneprobe"));
        if (ModList.get().isLoaded("theoneprobe")) {
            CompatTOP.register();
        }
    }

    @SubscribeEvent
    public static void setupNonTagBasedRegistries(@Nonnull FMLCommonSetupEvent event) {
        logger.debug("Fired FMLCommonSetupEvent");
        BarrelModeRegistry.initialize();
        PacketHandler.registerMessages();
        ExNihiloInitialization.registerVanillaCompost();
        ExNihiloInitialization.registerDispenserFluids();
        ExNihiloStats.register();
    }

    private static void registerDispenserFluids() {
        DefaultDispenseItemBehavior idispenseitembehavior = new DefaultDispenseItemBehavior(){
            @Nonnull
            private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

            @Nonnull
            public ItemStack m_7498_(@Nonnull BlockSource pSource, @Nonnull ItemStack pStack) {
                BucketItem bucketitem = (BucketItem)pStack.m_41720_();
                BlockPos blockpos = pSource.m_7961_().m_142300_((Direction)pSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                ServerLevel world = pSource.m_7727_();
                if (bucketitem.m_142073_(null, (Level)world, blockpos, null)) {
                    bucketitem.m_142131_(null, (Level)world, pStack, blockpos);
                    return new ItemStack((ItemLike)Items.f_42446_);
                }
                return this.defaultDispenseItemBehavior.m_6115_(pSource, pStack);
            }
        };
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ExNihiloItems.SEA_WATER_BUCKET.get()), (DispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.m_52672_((ItemLike)((ItemLike)ExNihiloItems.WITCH_WATER_BUCKET.get()), (DispenseItemBehavior)idispenseitembehavior);
    }

    private static void registerVanillaCompost() {
        ExNihiloInitialization.createMCCompost(((SeedBaseItem)((Object)ExNihiloItems.SEED_OAK.get())).m_5456_());
        ExNihiloInitialization.createMCCompost(((SeedBaseItem)((Object)ExNihiloItems.SEED_SPRUCE.get())).m_5456_());
        ExNihiloInitialization.createMCCompost(((SeedBaseItem)((Object)ExNihiloItems.SEED_BIRCH.get())).m_5456_());
        ExNihiloInitialization.createMCCompost(((SeedBaseItem)((Object)ExNihiloItems.SEED_JUNGLE.get())).m_5456_());
        ExNihiloInitialization.createMCCompost(((SeedBaseItem)((Object)ExNihiloItems.SEED_ACACIA.get())).m_5456_());
        ExNihiloInitialization.createMCCompost(((SeedBaseItem)((Object)ExNihiloItems.SEED_DARK_OAK.get())).m_5456_());
        ExNihiloInitialization.createMCCompost(((SeedBaseItem)((Object)ExNihiloItems.SEED_CACTUS.get())).m_5456_());
        ExNihiloInitialization.createMCCompost(((SeedBaseItem)((Object)ExNihiloItems.SEED_SUGARCANE.get())).m_5456_());
        ExNihiloInitialization.createMCCompost(((SeedBaseItem)((Object)ExNihiloItems.SEED_CARROT.get())).m_5456_());
        ExNihiloInitialization.createMCCompost(((SeedBaseItem)((Object)ExNihiloItems.SEED_POTATO.get())).m_5456_());
        ExNihiloInitialization.createMCCompost(((SeedBaseItem)((Object)ExNihiloItems.SEED_SWEET_BERRY.get())).m_5456_());
        ExNihiloInitialization.createMCCompost(((SeedBaseItem)((Object)ExNihiloItems.SEED_KELP.get())).m_5456_());
        ExNihiloInitialization.createMCCompost(((SeedBaseItem)((Object)ExNihiloItems.SEED_PICKLE.get())).m_5456_());
        ExNihiloInitialization.createMCCompost(((SeedBaseItem)((Object)ExNihiloItems.SEED_BAMBOO.get())).m_5456_());
        ExNihiloInitialization.createMCCompost(((SeedBaseItem)((Object)ExNihiloItems.SEED_FERN.get())).m_5456_());
        ExNihiloInitialization.createMCCompost(((SeedBaseItem)((Object)ExNihiloItems.SEED_LARGE_FERN.get())).m_5456_());
        ExNihiloInitialization.createMCCompost(((ResourceItem)((Object)ExNihiloItems.GRASS_SEED.get())).m_5456_());
        ExNihiloInitialization.createMCCompost(((ResourceItem)((Object)ExNihiloItems.MYCELIUM_SPORE.get())).m_5456_());
        ExNihiloInitialization.createMCCompost((Item)ExNihiloItems.SILKWORM.get());
        ExNihiloInitialization.createMCCompost((Item)ExNihiloItems.COOKED_SILKWORM.get());
    }

    private static void createMCCompost(Item item) {
        ComposterBlock.f_51914_.put((Object)item, 0.3f);
    }

    private static <R extends Recipe<?>> List<R> filterRecipes(@Nonnull Collection<Recipe<?>> recipes, @Nonnull Class<R> recipeClass, @Nonnull RecipeType<R> recipeType) {
        logger.debug("Filter Recipes, Class: " + recipeClass + ", Recipe Type: " + recipeType);
        return recipes.stream().filter(iRecipe -> iRecipe.m_6671_() == recipeType).map(recipeClass::cast).collect(Collectors.toList());
    }

    private static void loadRecipes(@Nonnull RecipeManager manager) {
        logger.debug("Loading Recipes");
        Collection recipes = manager.m_44051_();
        if (recipes.isEmpty()) {
            return;
        }
        ExNihiloRegistries.HAMMER_REGISTRY.setRecipes(ExNihiloInitialization.filterRecipes(recipes, HammerRecipe.class, HammerRecipe.RECIPE_TYPE));
        ExNihiloRegistries.CROOK_REGISTRY.setRecipes(ExNihiloInitialization.filterRecipes(recipes, CrookRecipe.class, CrookRecipe.RECIPE_TYPE));
        ExNihiloRegistries.COMPOST_REGISTRY.setRecipes(ExNihiloInitialization.filterRecipes(recipes, CompostRecipe.class, CompostRecipe.RECIPE_TYPE));
        ExNihiloRegistries.FLUID_BLOCK_REGISTRY.setRecipes(ExNihiloInitialization.filterRecipes(recipes, FluidItemRecipe.class, FluidItemRecipe.RECIPE_TYPE));
        ExNihiloRegistries.FLUID_ON_TOP_REGISTRY.setRecipes(ExNihiloInitialization.filterRecipes(recipes, FluidOnTopRecipe.class, FluidOnTopRecipe.RECIPE_TYPE));
        ExNihiloRegistries.FLUID_TRANSFORM_REGISTRY.setRecipes(ExNihiloInitialization.filterRecipes(recipes, FluidTransformRecipe.class, FluidTransformRecipe.RECIPE_TYPE));
        ExNihiloRegistries.CRUCIBLE_REGISTRY.setRecipes(ExNihiloInitialization.filterRecipes(recipes, CrucibleRecipe.class, CrucibleRecipe.RECIPE_TYPE));
        ExNihiloRegistries.HEAT_REGISTRY.setRecipes(ExNihiloInitialization.filterRecipes(recipes, HeatRecipe.class, HeatRecipe.RECIPE_TYPE));
        ExNihiloRegistries.SIEVE_REGISTRY.setRecipes(ExNihiloInitialization.filterRecipes(recipes, SieveRecipe.class, SieveRecipe.RECIPE_TYPE));
    }

    private static void overrideOres() {
        if (Config.enableOreOverride()) {
            ExNihiloItems.COPPER.setEnabled(Config.enableCopper());
            ExNihiloItems.LEAD.setEnabled(Config.enableLead());
            ExNihiloItems.LEAD.setEnabled(Config.enableLead());
            ExNihiloItems.NICKEL.setEnabled(Config.enableNickel());
            ExNihiloItems.SILVER.setEnabled(Config.enableSilver());
            ExNihiloItems.TIN.setEnabled(Config.enableTin());
            ExNihiloItems.ALUMINUM.setEnabled(Config.enableAluminum());
            ExNihiloItems.PLATINUM.setEnabled(Config.enablePlatinum());
            ExNihiloItems.URANIUM.setEnabled(Config.enableUranium());
            ExNihiloItems.ZINC.setEnabled(Config.enableZinc());
            ExNihiloItems.IRON.setEnabled(Config.enableIron());
            ExNihiloItems.GOLD.setEnabled(Config.enableGold());
        }
    }

    private static void registerOreCompat() {
        logger.debug("Register ore compatibility");
        ExNihiloItems.IRON.setEnabled(true);
        ExNihiloItems.GOLD.setEnabled(true);
        logger.debug("Immersive Engineering detected: " + ModList.get().isLoaded("immersiveengineering"));
        if (ModList.get().isLoaded("immersiveengineering")) {
            logger.debug("Added Immersive Engineering");
            ExNihiloItems.ALUMINUM.setEnabled(true);
            ExNihiloItems.COPPER.setEnabled(true);
            ExNihiloItems.SILVER.setEnabled(true);
            ExNihiloItems.NICKEL.setEnabled(true);
            ExNihiloItems.LEAD.setEnabled(true);
            ExNihiloItems.URANIUM.setEnabled(true);
        }
        logger.debug("Create detected: " + ModList.get().isLoaded("create"));
        if (ModList.get().isLoaded("create")) {
            logger.debug("Added Create");
            ExNihiloItems.COPPER.setEnabled(true);
            ExNihiloItems.ZINC.setEnabled(true);
        }
    }
}

